/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import org.apache.log4j.Logger;

/**
 * @author Uday Mathur
 * @author Michael Pih
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/WorkflowAddForm.java#5 $
 */
class WorkflowAddForm extends BaseWorkflowForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/WorkflowAddForm.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(WorkflowAddForm.class);

    private final SingleSelectionModel m_model;

    WorkflowAddForm(final SingleSelectionModel model) {
        super("workflow", gz("cms.ui.workflow.add"));

        m_model = model;

        addProcessListener(new ProcessListener());
    }

    private class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();

            final String label = (String) m_title.getValue(state);
            final String description = (String) m_description.getValue(state);

            final WorkflowTemplate workflow = new WorkflowTemplate();
            workflow.setLabel(label);
            workflow.setDescription(description);
            workflow.save();

            final ContentSection section =
                CMS.getContext().getContentSection();
            section.addWorkflowTemplate(workflow);
            section.save();

            m_model.setSelectedKey(state, workflow.getID());
        }
    }
}
