/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.workflow.simple.Workflow;

import java.math.BigDecimal;

class ItemWorkflowSelectionModel extends ParameterSingleSelectionModel {
    ItemSelectionModel m_itemSel;
    public ItemWorkflowSelectionModel(BigDecimalParameter itemIdParameter) {
        super(itemIdParameter);
        m_itemSel = new ItemSelectionModel("com.arsdigita.cms.ContentItem",
                                           ContentItem.BASE_DATA_OBJECT_TYPE,
                                           itemIdParameter);
    }
    public ItemWorkflowSelectionModel(ItemSelectionModel m) {
        super(m.getStateParameter());
        m_itemSel = m;
    }

    public Object getSelectedKey(PageState state) {
        return Workflow.getObjectWorkflowID
            ((BigDecimal)super.getSelectedKey(state));
    }

    public ItemSelectionModel getItemSelectionModel() {
        return m_itemSel;
    }
}
