/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.cms.ui.BaseForm;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.kernel.User;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.TaskComment;
import org.apache.log4j.Logger;

/**
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/CommentAddForm.java#7 $
 */
class CommentAddForm extends BaseForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/CommentAddForm.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(CommentAddForm.class);

    private final TaskRequestLocal m_task;
    private final TextArea m_comment;

    public CommentAddForm(final TaskRequestLocal task) {
        super("addComment", gz("cms.ui.workflow.task.comment.add"));

        m_task = task;

        m_comment = new TextArea("Comment");
        m_comment.setWrap(TextArea.SOFT);
        m_comment.setRows(5);
        m_comment.setCols(40);

        addComponent(m_comment);

        addAction(new Finish());
        addAction(new Cancel());

        addProcessListener(new ProcessListener());
    }

    private class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            s_log.debug("Processing comment add");

            final PageState state = e.getPageState();
            final CMSTask task = m_task.getTask(state);
            final User user = Web.getContext().getUser();

            final TaskComment comment = new TaskComment
                (task.getID(), user, (String) m_comment.getValue(state));

            comment.save();

            task.addComment(comment);

            task.save();
        }
    }
}
