/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.role;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.kernel.Role;
import com.arsdigita.util.Assert;

public abstract class RoleRequestLocal extends RequestLocal {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/role/RoleRequestLocal.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    public final Role getRole(final PageState state) {
        final Role role = (Role) get(state);

        Assert.assertNotNull(role, "Role role");

        return role;
    }
}
