/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.role;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.CMS;
import com.arsdigita.kernel.Role;
import org.apache.log4j.Logger;

/**
 * @author Michael Pih
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/role/RoleEditForm.java#7 $
 */
final class RoleEditForm extends BaseRoleForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/role/RoleEditForm.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(RoleEditForm.class);

    private final RoleRequestLocal m_role;
    private final boolean m_useViewersGroup;

    public RoleEditForm(RoleRequestLocal role, boolean useViewersGroup) {
        super("EditStaffRole", gz("cms.ui.role.edit"), useViewersGroup);

        m_role = role;
        m_useViewersGroup = useViewersGroup;

        m_name.addValidationListener(new NameUniqueListener(m_role));

        addInitListener(new InitListener());
        addProcessListener(new ProcessListener());
    }

    private class InitListener implements FormInitListener {
        public final void init(final FormSectionEvent e) {
            final PageState state = e.getPageState();
            final Role role = m_role.getRole(state);

            m_name.setValue(state, role.getName());
            m_description.setValue(state, role.getDescription());

            final String[] privileges = RoleFactory.getRolePrivileges
                (CMS.getContext().getContentSection(), role);

            m_privileges.setValue(state, privileges);
        }
    }

    private class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();

            final Role role = m_role.getRole(state);
            role.setName((String) m_name.getValue(state));
            role.setDescription((String) m_description.getValue(state));
            role.save();

            RoleFactory.updatePrivileges
                (role,
                 (String[]) m_privileges.getValue(state),
                 CMS.getContext().getContentSection());

            role.save();
        }
    }
}
