/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.portlet;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.cms.portlet.ContentSectionsPortlet;
import com.arsdigita.cms.portlet.ContentSectionsQuery;
import com.arsdigita.xml.Element;


public class ContentSectionsPortletRenderer extends AbstractPortletRenderer {
    private ContentSectionsPortlet m_portlet;

    public ContentSectionsPortletRenderer(ContentSectionsPortlet portlet) {
        m_portlet = portlet;
    }

    public void generateBodyXML(PageState state,
                                Element parent) {
        Element content = parent.newChildElement("portlet:contentSections",
                                       "http://www.arsdigita.com/portlet/1.0");

        ContentSectionsQuery sections = new ContentSectionsQuery();
        while (sections.next()) {
            Element child = content.newChildElement("portlet:contentSection",
                                       "http://www.arsdigita.com/portlet/1.0");

            child.addAttribute("name", sections.getName());
            child.addAttribute("url", sections.getURL());
        }
    }
}
