/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.portlet;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.cms.portlet.ContentItemPortlet;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.util.ui.RequestLocalSelectionModel;
import com.arsdigita.xml.Element;


public class ContentItemPortletRenderer extends AbstractPortletRenderer {
    private static org.apache.log4j.Logger s_log =
        org.apache.log4j.Logger.getLogger(ContentItemPortletRenderer.class);

    private RequestLocalSelectionModel m_item = new RequestLocalSelectionModel();
    private ContentItemPortlet m_portlet;

    public ContentItemPortletRenderer(ContentItemPortlet portlet) {
        m_portlet = portlet;
    }

    public void generateBodyXML(PageState state,
                                Element parent) {
        Element content = parent.newChildElement("portlet:contentItem",
                                       "http://www.arsdigita.com/portlet/1.0");
        
        ContentItem item = m_portlet.getContentItem();
        if (item != null) {
            m_item.setSelectedObject(state, item);

            Element contentItem = content.newChildElement
                ( "cms:item", CMS.CMS_XML_NS );

            DomainObjectXMLRenderer renderer =
                new DomainObjectXMLRenderer(contentItem);

            renderer.setWrapAttributes( true );
            renderer.setWrapRoot( false );
            renderer.setWrapObjects( false );

            renderer.walk( item, SimpleXMLGenerator.ADAPTER_CONTEXT );
        }
    }

    public Object getCacheKey() {
        ContentItem item = m_portlet.getContentItem();
        return item == null ? null : item;
    }

    // For a given cache key a contnet item is *never* dirty,
    // since upon republishing of a live item, the item_id
    // changes!
    public boolean isDirty() {
        return false;
    }

}
