/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.permissions;


import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.cms.ui.UserSearchForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.xml.Element;

/**
 * <p>This panel allows a staff administrator to search for users and add
 * them to a staff role for the content section.</p>
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #8 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class ObjectAddSearchAdmin extends SimpleContainer {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/permissions/ObjectAddSearchAdmin.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private ACSObjectSelectionModel m_object;

    private UserSearchForm m_searchForm;
    private ObjectAddAdmin m_addPanel;
    private ActionLink m_return;

    public ObjectAddSearchAdmin(ACSObjectSelectionModel model) {
        super();

        m_object = model;

        m_searchForm = new UserSearchForm("ObjectAdminSearch");
        add(m_searchForm);

        m_addPanel = getObjectAddAdmin(model, m_searchForm);
        add(m_addPanel);

        m_addPanel.addCompletionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    fireCompletionEvent(e.getPageState());
                }
            });

        m_return = new ActionLink( (String) GlobalizationUtil.globalize("cms.ui.permissions.return_to_object_info").localize());
        m_return.setClassAttr("actionLink");
        m_return.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    fireCompletionEvent(e.getPageState());
                }
            });
        add(m_return);
    }


    /**
     * Displays the appropriate form(s).
     */
    public void generateXML(PageState state, Element parent) {
        FormData data = m_searchForm.getFormData(state);
        FormData data2 = m_addPanel.getForm().getFormData(state);

        if ( data != null && (data.isSubmission() || data2.isSubmission()) ) {
            m_addPanel.setVisible(state, true);
        } else {
            m_addPanel.setVisible(state, false);
        }
        super.generateXML(state, parent);
    }


    /**
     * This returns the form for adding object administrators
     */
    protected ObjectAddAdmin getObjectAddAdmin(ACSObjectSelectionModel model,
                                               UserSearchForm searchForm) {
        return new ObjectAddAdmin(model, searchForm.getSearchWidget());
    }
}
