/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.lifecycle.LifecycleDefinitionCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.util.UncheckedWrapperException;

import java.util.NoSuchElementException;

/**
 * Loads all the current lifecycles from the database so that they may
 * be displayed in a list.
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @author Jack Chung (flattop@arsdigita.com)
 * @version $Revision: #5 $ $DateTime: 2004/04/07 16:07:11 $
 */
public final class LifecycleListModelBuilder extends LockableImpl
        implements ListModelBuilder {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/LifecycleListModelBuilder.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    public final ListModel makeModel(final List l, final PageState state) {
        return new Model(state);
    }

    private class Model implements ListModel {
        private LifecycleDefinitionCollection m_cycles;

        public Model(final PageState state) {
            m_cycles = getCollection(state);
        }

        private final LifecycleDefinitionCollection getCollection
                (final PageState state) {
            ContentSection section = CMS.getContext().getContentSection();

            // MP: Remove this extra step if possible.  The content
            // section needs to be refreshed before fetching the
            // lifecycle definitions.

            try {
                section = new ContentSection(section.getOID());
            } catch (DataObjectNotFoundException donfe) {
                throw new UncheckedWrapperException(donfe);
            }

            final LifecycleDefinitionCollection cycles =
                section.getLifecycleDefinitions();

            cycles.addOrder("upper(label)");

            return cycles;
        }

        public boolean next() throws NoSuchElementException {
            return m_cycles.next();
        }

        public Object getElement() {
            return m_cycles.getLifecycleDefinition().getLabel();
        }

        public String getKey() {
            return m_cycles.getLifecycleDefinition().getID().toString();
        }
    }
}
