/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.folder;


import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;

import java.math.BigDecimal;

/**
 * Keeps track of the selection of an item in a folder. The objects that
 * are selected by this model are all subclasses of {@link
 * com.arsdigita.cms.Folder}.
 *
 * @author <a href="mailto:lutter@arsdigita.com">David Lutterkort</a>
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/folder/FolderSelectionModel.java#10 $
 */
public class FolderSelectionModel
    extends ItemSelectionModel {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/folder/FolderSelectionModel.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public FolderSelectionModel(String name) {
        super(Folder.BASE_DATA_OBJECT_TYPE, Folder.BASE_DATA_OBJECT_TYPE, name);
    }

    public FolderSelectionModel(final SingleSelectionModel model) {
        super(Folder.BASE_DATA_OBJECT_TYPE, Folder.BASE_DATA_OBJECT_TYPE, model);
    }

    public Object getSelectedKey(PageState s) {
        // FIXME: this code will go away once parameter models support init listeners
        Object result = super.getSelectedKey(s);
        if ( result == null ) {
            result = getRootFolderID(s);
            setSelectedKey(s, result);
        }
        return result;
    }

    /**
     * Clear the selection by resetting it to the root folder id.
     *
     * @param s represents the curent request.
     */
    public void clearSelection(PageState s) {
        setSelectedKey(s, getRootFolderID(s));
    }

    /**
     * Return the ID of the root folder. By default, this is the root folder
     * of the content section in which the current request is made. If this
     * model is to be used outside a content section, this method has to be
     * overriden appropriately.
     *
     * @param s represents the current request
     * @return the ID of the root folder
     *
     * @pre s != null
     * @post return != null
     */
    protected BigDecimal getRootFolderID(PageState s) {
        ContentSection sec = CMS.getContext().getContentSection();
        return sec.getRootFolder().getID();
    }

    /**
     * Return true, since this selection model will always have
     * a folder selected in it
     */
    public boolean isSelected(PageState s) {
        return true;
    }

}
