/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.Folder;


/**
 * Implements functionality for renaming a folder. Most code taken from FolderCreator. Need to refactor out base
 * functionality of FolderEditor & Creator.
 *
 * @author Jon Orris (jorris@arsdigita.com)
 *
 * @version $Revision: #8 $ $DateTime: 2004/04/07 16:07:11 $
 */

public class FolderEditor extends FolderForm {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/folder/FolderEditor.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public FolderEditor(String name, FolderSelectionModel folder) {
        super(name, folder);
    }


    /**
     * Initialize the form with name & label of folder being edited.
     */
    public void init(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        FormData data = e.getFormData();
        Folder folder = getCurrentFolder(s);
        data.put(NAME, folder.getName());
        data.put(TITLE, folder.getLabel());
    }


    public void process(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        FormData data = e.getFormData();
        Folder folder = getCurrentFolder(s);

        updateFolder(folder, (String)data.get(NAME), (String)data.get(TITLE));
    }
}
