/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.folder;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.cms.Folder;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;

import java.math.BigDecimal;

final class ChildUniqueValidationListener implements ParameterListener {
    private final FolderRequestLocal m_parent;

    public ChildUniqueValidationListener(final FolderRequestLocal parent) {
        m_parent = parent;
    }

    public final void validate(final ParameterEvent e)
            throws FormProcessException {
        final PageState state = e.getPageState();
        final String name = (String) e.getParameterData().getValue();

        if (name != null) {
            validateNameUniqueness(m_parent.getFolder(state), name);
        }
    }

    private void validateNameUniqueness(final Folder parent,
                                        final String name)
            throws FormProcessException {
        final DataQuery query = SessionManager.getSession().retrieveQuery
            ("com.arsdigita.cms.validateUniqueItemName");
        query.setParameter("parentId", parent.getID());
        query.setParameter("name", name);

        if (query.next()) {
            long count = ((BigDecimal) query.get("size")).longValue();
            
            query.close();
            
            if (count > 0) {
                throw new FormProcessException
                    ("An item with this name already exists");
            }
        } else {
            throw new IllegalStateException();
        }
    }
}
