/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.categorization.CategoryPurpose;

import java.util.Iterator;

/**
 * A {@link ListModel} that iterates over categories via an iterator
 */
public class CategoryPurposeIteratorListModel implements ListModel {

    private Iterator m_iter;
    private CategoryPurpose m_cat;

    /**
     * Construct a new <code>CategoryPurposeIteratorListModel</code>
     *
     * @param iter an {@link Iterator} over all the categories
     *   which this model will supply
     */
    public CategoryPurposeIteratorListModel(Iterator iter) {
        m_iter = iter;
        m_cat = null;
    }

    public boolean next() {
        if(m_iter.hasNext()) {
            m_cat = (CategoryPurpose)m_iter.next();
            return true;
        } else {
            return false;
        }
    }

    public Object getElement() {
        return m_cat.getName();
    }

    public String getKey() {
        return m_cat.getID().toString();
    }
}
