/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.util.LockableImpl;

/**
 * A List of all secondary parents of the current category.
 *
 * @author Stanislav Freidin (stas@arsdigita.com)
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategoryLinks.java#11 $
 */
public class CategoryLinks extends List {
    public final static String SUB_CATEGORY = "sc";

    private final CategoryRequestLocal m_parent;
    private final SingleSelectionModel m_model;

    public CategoryLinks(final CategoryRequestLocal parent,
                         final SingleSelectionModel model) {
        super(new ParameterSingleSelectionModel
              (new BigDecimalParameter(SUB_CATEGORY)));
        setIdAttr("category_links_list");

        m_parent = parent;
        m_model = model;

        setModelBuilder(new LinkedCategoryModelBuilder());

        // Select the category in the main tree when the
        // user selects it here
        addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    final PageState state = e.getPageState();
                    final String id = (String) getSelectedKey(state);

                    if (id != null) {
                        m_model.setSelectedKey(state, id);
                    }
                }
            });

        final Label label = new Label
            (GlobalizationUtil.globalize("cms.ui.category.linked.none"));
        label.setFontWeight(Label.ITALIC);
        setEmptyView(label);
    }

    private class LinkedCategoryModelBuilder extends LockableImpl
            implements ListModelBuilder {
        public ListModel makeModel(List list, PageState state) {
            final Category category = m_parent.getCategory(state);

            if (category != null && !category.isRoot()
                   && category.getParentCategoryCount() > 1) {

                // Do not show the default parent
                Category parent = category.getDefaultParentCategory();

                return new CategoryCollectionListModel
                    (category.getParents(),
                     parent == null ? null : parent.getID());
            } else {
                return List.EMPTY_MODEL;
            }
        }
    }

}
