/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.categorization.Category;
import com.arsdigita.dispatcher.AccessDeniedException;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

/**
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategoryAddForm.java#9 $
 */
final class CategoryAddForm extends BaseCategoryForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/category/CategoryAddForm.java#9 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (CategoryAddForm.class);

    private final SingleSelectionModel m_model;

    /**
     * Constructor.
     */
    public CategoryAddForm(final CategoryRequestLocal parent,
                           final SingleSelectionModel model) {
        super("AddSubcategories", gz("cms.ui.category.add"), parent);

        m_model = model;

        //m_name.addValidationListener(new NameUniqueListener(null, m_name, NameUniqueListener.NAME_FIELD));
        //m_url.addValidationListener(new NameUniqueListener(null, m_url, NameUniqueListener.URL_FIELD));
	
        addProcessListener(new ProcessListener());
    }

    private final class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            s_log.debug("Adding a category");

            final PageState state = e.getPageState();

            final Category parent = m_parent.getCategory(state);
            final String name = (String) m_name.getValue(state);
            final String description = (String) m_description.getValue(state);
	    final String url = (String) m_url.getValue(state);
	    final String isAbstract = (String) m_isAbstract.getValue(state);

            Assert.assertNotNull(parent, "Category parent");

            if (s_log.isDebugEnabled()) {
                s_log.debug("Using parent category " + parent + " to " +
                            "create new category");
            }

            if (parent.canEdit()) {
                final Category category = new Category(name, description, url);
		// this seems anti-intuitive but the question is "can you place
		// items in this category.  If the user says "yes" then the
		// category is not abstract
		if ("yes".equals(isAbstract)) {
		    category.setAbstract(false);
		} else if ("no".equals(isAbstract)) {
		    category.setAbstract(true);
		}
                category.save(); // XXX this is necessary?

                parent.addChild(category);
                parent.save();

                category.setDefaultParentCategory(parent);
                category.save();

                m_model.setSelectedKey(state, category.getID());
            } else {
                // XXX user a better exception here.
                // PermissionException doesn't work for this case.
                throw new AccessDeniedException();
            }
        }
    }
}
