/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.authoringkit;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.AuthoringStep;
import com.arsdigita.cms.ui.type.ContentTypeRequestLocal;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.util.UncheckedWrapperException;

import java.math.BigDecimal;


/**
 * This class contains a form component to edit an authoring step
 *
 * @author Jack Chung (flattop@arsdigita.com)
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 */
public class EditStep extends AddStep {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoringkit/EditStep.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    protected final SingleSelectionModel m_steps;


    /**
     * @param types The content type selection model. This is to tell the form
     *   which content type is selected.
     * @param steps The authoring step selection model. This is to tell the form
     *   which step is selected for editing.
     */
    public EditStep(ContentTypeRequestLocal type, SingleSelectionModel steps) {
        super(type);

        m_steps = steps;
    }

    /**
     * Form init listener which initializes form values.
     */
    public void init(FormSectionEvent e) {
        FormData data = e.getFormData();
        PageState state = e.getPageState();

        AuthoringKit kit = getKit(state);
        AuthoringStep step = getStep(state);

        BigDecimal id = step.getID();
        String label =  step.getLabel();
        String labelKey =  step.getLabelKey();
        String labelBundle =  step.getLabelBundle();
        String description =  step.getDescription();
        String descriptionKey =  step.getDescriptionKey();
        String descriptionBundle =  step.getDescriptionBundle();
        String component =  step.getComponent();
        BigDecimal ordering = kit.getOrdering(step);

        data.put(m_id.getName(), id);
        data.put(m_labelKey.getName(), (labelKey == null) ? label : labelKey);
        data.put(m_labelBundle.getName(), labelBundle);
        data.put(m_descriptionKey.getName(), (descriptionKey == null) ? description : descriptionKey);
        data.put(m_descriptionBundle.getName(), descriptionBundle);
        data.put(m_component.getName(), component);
        data.put(m_ordering.getName(), ordering);
    }


    protected AuthoringStep getStep(PageState state) {
        String step_key = (String) m_steps.getSelectedKey(state);
        BigDecimal stepID = new BigDecimal(step_key);

        try {
            return new AuthoringStep(stepID);
        } catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("Authoring Step ID#" + step_key +
                                       " not found", ex);
        }
    }
}
