/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.web.RedirectSignal;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.categorization.RootCategoryCollection;

import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.util.Classes;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;

public class ItemCategoryStep extends SimpleContainer 
    implements Resettable{
    
    private static final Logger s_log = Logger.getLogger(ItemCategoryStep.class);

    private ItemCategorySummary m_summary;
    private SimpleComponent m_add;
    private BigDecimalParameter m_root;
    private StringParameter m_mode;

    public ItemCategoryStep(ItemSelectionModel itemModel, 
                            AuthoringKitWizard parent) {
        super("cms:categoryStep", CMS.CMS_XML_NS);

        m_root = new BigDecimalParameter("root");
        m_mode = new StringParameter("mode");

        m_summary = new ItemCategorySummary();
        
        m_summary.registerAction(ItemCategorySummary.ACTION_ADD,
                                 new AddActionListener("plain"));
        m_summary.registerAction(ItemCategorySummary.ACTION_ADD_JS,
                                 new AddActionListener("javascript"));
        
        Class addForm = ContentSection.getConfig().getCategoryAuthoringAddForm();
        m_add = (SimpleComponent)
            Classes.newInstance(addForm,
                                new Class[] { BigDecimalParameter.class,
                                              StringParameter.class },
                                new Object[] { m_root, m_mode });
        m_add.addCompletionListener(new ResetListener());
        
        add(m_summary);
        add(m_add);
    }

    public void register(Page p) {
        super.register(p);
        
        p.setVisibleDefault(m_add, false);

        p.addGlobalStateParam(m_root);
        p.addGlobalStateParam(m_mode);
    }

    public void reset(PageState state) {
        state.setValue(m_root, null);
        state.setValue(m_mode, null);
        
        m_summary.setVisible(state, true);
        m_add.setVisible(state, false);        
    }

    private class AddActionListener implements ActionListener {
        private String m_mode;

        public AddActionListener(String mode) {
            m_mode = mode;
        }

        public void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            
            state.setValue(m_root,
                           new BigDecimal(state.getControlEventValue()));

            state.setValue(ItemCategoryStep.this.m_mode,
                           m_mode);

            m_summary.setVisible(state, false);
            m_add.setVisible(state, true);
        }
    }
    
    private class ResetListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            reset(state);
            throw new RedirectSignal(state.toURL(), true);
        }
    }
}
