/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.BoxPanel;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.OID;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.CMS;

import java.util.List;
import java.util.ArrayList;
import java.math.BigDecimal;

public class ItemCategoryForm extends Form {
    
    private CategoryWidget m_category;
    private SaveCancelSection m_buttons;

    public ItemCategoryForm(BigDecimalParameter root,
                            StringParameter mode) {
        super("category", new BoxPanel(BoxPanel.VERTICAL));

        m_category = new CategoryWidget("category", 
                                        root,
                                        mode);
        m_category.addValidationListener(new NotNullValidationListener());
        m_buttons = new SaveCancelSection();

        add(m_category);
        add(m_buttons);
        
        addInitListener(new FormInitListener() {
                public void init(FormSectionEvent ev) 
                    throws FormProcessException {
                    
                    PageState state = ev.getPageState();

                    ContentItem item = CMS.getContext().getContentItem();
                    ContentBundle bundle = (ContentBundle)item.getParent();
                    
                    List ids = new ArrayList();
                    CategoryCollection cats = bundle.getCategoryCollection();
                    while (cats.next()) {
                        ids.add(cats.getCategory().getID());
                    }
                    
                    m_category.setValue(state,
                                        ids.toArray(new BigDecimal[ids.size()]));
                }
            });

        addProcessListener(new FormProcessListener() {
                public void process(FormSectionEvent ev)
                    throws FormProcessException {

                    PageState state = ev.getPageState();

                    ContentItem item = CMS.getContext().getContentItem();
                    ContentBundle bundle = (ContentBundle)item.getParent();
                    
                    BigDecimal[] ids = (BigDecimal[])m_category.getValue(state);
                    for (int i = 0 ; i < ids.length ; i++) {
                        Category cat = (Category)
                            DomainObjectFactory.newInstance(
                                new OID(Category.BASE_DATA_OBJECT_TYPE,
                                        ids[i]));
                        
                        cat.addChild(bundle);
                    }

                    fireCompletionEvent(state);
                }
            });
        addSubmissionListener(new FormSubmissionListener() {
                public void submitted(FormSectionEvent ev) 
                    throws FormProcessException {

                    PageState state = ev.getPageState();

                    if (m_buttons.getCancelButton().isSelected(state)) {
                        fireCompletionEvent(state);
                        throw new FormProcessException("cancelled");
                    }
                }
            });
    }
}
