/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.ui.util.UniqueStringValidationListener;


/**
 * Ensures that the name of the item is unique by resolving the
 * would-be URL of the item. If an item already "exists" at the URL in the
 * current context, then the name is invalid.
 *
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #7 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class UniqueItemNameValidationListener
    extends UniqueStringValidationListener {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/UniqueItemNameValidationListener.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";


    private final static String ERROR_MSG =
        "An item with this name already exists.";

    /**
     * Constructor.
     *
     * @param widget The widget that contains the name of the item.
     * @pre ( widget != null )
     */
    public UniqueItemNameValidationListener(Widget widget) {
        this(widget, ERROR_MSG);
    }

    /**
     * Constructor.
     *
     * @param widget The widget that contains the name of the item.
     * @param errorMsg The error message
     * @pre ( widget != null )
     */
    public UniqueItemNameValidationListener(Widget widget, String errorMsg) {
        super(widget, errorMsg);
    }


    /**
     * Returns true if the string value is unique, false otherwise.
     *
     * @param state The page state
     * @param value The submitted string value
     * @return true if the string value is unique, false otherwise
     */
    protected boolean isUnique(PageState state, String value) {

        // Fetch the current content section.
        ContentSection section = getContentSection(state);

        ItemResolver resolver = section.getItemResolver();

        // Resolve the would-be URL to a content item.
        String context = resolver.getCurrentContext(state);
        ContentItem item = resolver.getItem(section, value, context);

        return ( item != null );
    }

    /**
     * Fetch the current content section.
     *
     * @param state The page state
     * @return The current content section
     * @pre ( state != null )
     */
    protected ContentSection getContentSection(PageState state) {
        ContentSection section = CMS.getContext().getContentSection();
        return section;
    }

}
