/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.cms.CMS;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.io.IOException;


/**
 * This list offers the option for the code to provide the developer
 * with links to sort the given categories.
 *
 * NOTE: This UI currently does not scale well with large numbers of items
 * since it just lists all of them.  It would probably be nice to integrate
 * a paginator as well to as to allow the user to move an item in large
 * distances and to insert an item in the middle.  Right now, when you add
 * an item it is just placed at the end.  However, if you want the item to
 * appear in the middle then you must hit the "up" arrow n/2 times where
 * n is the number of items in the list.  This clearly is not a good setup.
 *
 * @author Randy Graebner (randyg@alum.mit.edu)
 * @version $Revision: #8 $ $DateTime: 2004/04/07 16:07:11 $
 */
public abstract class SortableList extends List {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/SortableList.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final org.apache.log4j.Logger s_log =
        org.apache.log4j.Logger.getLogger(SortableList.class);

    // It would be really nice if this used the save variable as is
    // used by List but because List has it as private, we cannot do that.
    private static final String SELECT_EVENT = "s";
    protected static final String PREV_EVENT = "prev";
    protected static final String NEXT_EVENT = "next";
    //private boolean m_sortItems;

    /**
     *  This just makes a standard
     *  {@link SortableList}
     */
    public SortableList(ParameterSingleSelectionModel model) {
        super(model);
    }

    /**
     *  This geneates the XML as specified by the arguments pass in to
     *  the constructor.
     */
    public void generateXML(PageState state, Element parent) {
        if (!isVisible(state)) {
            return;
        }

        // They want the special sort items
        ListModel m = getModel(state);

        if (!m.next()) {
            super.generateXML(state, parent);
            return;
        }

        // because m.next() returned true, we know there are items
        // in the list
        Element list = parent.newChildElement
            ("cms:sortableList", CMS.CMS_XML_NS);
        exportAttributes(list);

        Component c;
        Object selKey = getSelectedKey(state);
        int i = 0;
        boolean hasNext;
        do {
            Element item = list.newChildElement
                (BebopConstants.BEBOP_CELL, BEBOP_XML_NS);
            item.addAttribute("configure", "true");

            String key = m.getKey();
            Assert.assertNotNull(key);

            // Converting both keys to String for comparison
            // since ListModel.getKey returns a String
            boolean selected = (selKey != null) &&
                key.equals(selKey.toString());

            if ( selected ) {
                item.addAttribute("selected", "selected");
            }

            generateLabelXML(state, item,
                             new Label(m.getElement().toString()), key);

            hasNext = m.next();

            // Add attributes containing URLs that fire control events
            // for various portlet actions
            try {
                // Maybe add attribute containing URL for "move up" link
                if (i > 0) {
                    state.setControlEvent(this, PREV_EVENT, key);
                    item.addAttribute("prevURL", state.stateAsURL());
                }

                // Maybe add attribute containing URL for "move down" link
                if (hasNext) {
                    state.setControlEvent(this, NEXT_EVENT, key);
                    item.addAttribute("nextURL", state.stateAsURL());
                }

            } catch (IOException ex) {
                throw new IllegalStateException("Caught IOException: " +
                                                ex.getMessage());
            }
            i++;
        }  while (hasNext);

        state.clearControlEvent();
    }

    protected void generateLabelXML(PageState state, Element parent,
                                    Label label, String key) {
        state.setControlEvent(this, SELECT_EVENT, key);
        Component c = new ControlLink(label);
        c.generateXML(state, parent);
    }
}
