/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SectionLocaleCollection;
import com.arsdigita.util.LockableImpl;

import java.util.NoSuchElementException;


/**
 * Builds a list of locales registered to a content section.
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #7 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class LocalesListModelBuilder extends LockableImpl
    implements ListModelBuilder {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/LocalesListModelBuilder.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public LocalesListModelBuilder() {
        super();
    }

    public ListModel makeModel(List l, final PageState state) {
        return new ListModel() {

                private SectionLocaleCollection m_locales = getLocales(state);

                private SectionLocaleCollection getLocales(PageState param_state) {
                    ContentSection section = CMS.getContext().getContentSection();

                    SectionLocaleCollection locales = section.getLocales();
                    locales.addOrder("language");
                    locales.addOrder("country");
                    locales.addOrder("variant");
                    return locales;
                }

                public boolean next() throws NoSuchElementException {
                    return m_locales.next();
                }

                public Object getElement() {
                    return m_locales.getLocale().toJavaLocale().getDisplayName();
                }

                public String getKey() {
                    return m_locales.getLocale().getID().toString();
                }
            };
    }

}
