/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.TreeExpansionEvent;
import com.arsdigita.bebop.event.TreeExpansionListener;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.ui.folder.FolderSelectionModel;
import com.arsdigita.cms.ui.folder.FolderTree;
import com.arsdigita.cms.util.GlobalizationUtil;

import java.math.BigDecimal;

/**
 * A pane that contains a folder tree on the left and a folder
 * manipulator on the right.
 *
 * @author David LutterKort &lt;dlutter@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/ItemSearchBrowsePane.java#8 $
 */
public class ItemSearchBrowsePane extends CMSContainer
    implements Resettable, TreeExpansionListener, ChangeListener,
               FormProcessListener, FormSubmissionListener {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ItemSearchBrowsePane.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    FolderSelectionModel m_folderSel;
    FolderTree m_tree;
    ItemSearchFolderBrowser m_browser;

    public ItemSearchBrowsePane() {
        setClassAttr("sidebarNavPanel");
        setAttribute("navbar-title", "Folders");

        Label l = new Label(GlobalizationUtil.globalize("cms.ui.folder_browser"));
        l.setClassAttr("heading");
        add(l);

        m_folderSel = new FolderSelectionModel("folder");
        m_folderSel.addChangeListener(this);

        m_tree = new FolderTree(m_folderSel);
        m_tree.setClassAttr("navbar");
        m_tree.addTreeExpansionListener(this);
        add(m_tree);

        CMSContainer container = new CMSContainer();
        container.setClassAttr("main");

        m_browser = new ItemSearchFolderBrowser (m_folderSel);
        container.add( m_browser );
        container.add(m_browser.getPaginator());

        add( container );
    }

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam(this, m_folderSel.getStateParameter());
    }

    public void reset(PageState s) {
      //m_browser.reset(s);
    }

    public ItemSearchFolderBrowser getFolderBrowser() {
        return m_browser;
    }

    public final FolderSelectionModel getFolderSelectionModel() {
        return m_folderSel;
    }

    /**
     * sets the current level of expansion of the folder tree
     * and in the folder browser table
     */
    protected void setSelectedFolder(PageState s, String key) {

        //set the selected folder of the folder browser
        m_browser.getFolderSelectionModel().setSelectedKey(s, key);

        //set the selected folder of the folder tree
        m_folderSel.setSelectedKey(s, key);
        Folder current = (Folder) m_folderSel.getSelectedObject(s);
        Folder parent = (Folder) current.getParent();
        if ( parent != null ) {
            BigDecimal id = parent.getID();
            m_tree.expand(id.toString(), s);
        }
    }

    // Implement TreeExpansionListener

    public void treeCollapsed(TreeExpansionEvent e) {
        PageState s = e.getPageState();
        m_folderSel.setSelectedKey(s, e.getNodeKey());
    }

    public void treeExpanded(TreeExpansionEvent e) {
        return;
    }

    public void stateChanged(ChangeEvent e) {
        PageState s = e.getPageState();
        Folder current = (Folder) m_folderSel.getSelectedObject(s);
        Folder parent = (Folder) current.getParent();
        m_browser.getPaginator().reset(s);
        if ( parent != null ) {
            BigDecimal id = parent.getID();
            m_tree.expand(id.toString(), s);
        }
        //m_browser.getPermissionsPane().reset(s);
        //m_browser.setPermissionLinkVis(s);
    }

    public void process(FormSectionEvent e) {
        PageState s = e.getPageState();
	/*
        if ( e.getSource() == m_browser.getManipulator().getItemView() ) {
            // Hide everything except for the flat item list
            m_tree.setVisible(s, false);
        } else if ( e.getSource() == m_browser.getManipulator().getTargetSelector() ) {
            m_tree.setVisible(s, true);
        }
	*/
    }

    public void submitted(FormSectionEvent e) {
        PageState s = e.getPageState();
	/*
        if ( e.getSource() == m_browser.getManipulator().getTargetSelector() ) {
            if ( ! m_browser.getManipulator().getTargetSelector().isVisible(s) ) {
                m_tree.setVisible(s, true);
            }
        }
	*/
    }


}
