/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

import javax.servlet.http.HttpServletRequest;

/**
 * <p>Global navigation elements for the CMS admin UIs.</p>
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/GlobalNavigation.java#6 $
 */
class GlobalNavigation extends SimpleComponent {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/GlobalNavigation.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (GlobalNavigation.class);

    private final String m_centerPath;
    private final String m_wspcPath;
    private final String m_signOutPath;
    private final String m_helpPath;

    GlobalNavigation() {
        m_centerPath = Utilities.getWorkspaceURL();
        m_wspcPath = path(Initializer.WORKSPACE_PAGE_KEY);
        m_signOutPath = path(Initializer.LOGOUT_PAGE_KEY);
        m_helpPath = "/nowhere"; // We don't have this yet XXX.
    }

    public void generateXML(final PageState state, final Element parent) {
        if (isVisible(state)) {
            final HttpServletRequest sreq = state.getRequest();

            final Element nav = parent.newChildElement
                ("cms:globalNavigation", CMS.CMS_XML_NS);

            final String centerTitle = lz("cms.ui.content_center");
            final String wspcTitle = lz("cms.ui.my_workspace");
            final String signOutTitle = lz("cms.ui.sign_out");
            final String helpTitle = lz("cms.ui.help");

            link(sreq, nav, "cms:contentCenter", m_centerPath, centerTitle);
            link(sreq, nav, "cms:workspace", m_wspcPath, wspcTitle);
            link(sreq, nav, "cms:signOut", m_signOutPath, signOutTitle);
            link(sreq, nav, "cms:help", m_helpPath, helpTitle);
        }
    }

    private static String path(final String key) {
        return "/" + Initializer.getURL(key);
    }

    private static Element link(final HttpServletRequest sreq,
                                final Element parent,
                                final String name,
                                final String path,
                                final String title) {
        final Element link = parent.newChildElement(name, CMS.CMS_XML_NS);

        link.addAttribute("href", URL.there(sreq, path).toString());
        link.addAttribute("title", title);

        return link;
    }

    private static String lz(final String key) {
        return (String) ContentSectionPage.globalize(key).localize();
    }
}
