/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ImageAssetCollection;

/**
 * An {@link ImageBrowserModel} which displays all images in the
 * given ImageAssetCollection
 *
 * @author Stanislav Freidin
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/DefaultImageBrowserModel.java#5 $
 *
 */
public class DefaultImageBrowserModel implements ImageBrowserModel {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/DefaultImageBrowserModel.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private ImageAssetCollection m_images;

    /**
     * Construct a new DefaultImageBrowserModel
     *
     * @param images The {@link ImageAssetCollection} whose images will
     *   be displayed
     */
    public DefaultImageBrowserModel(ImageAssetCollection images) {
        m_images = images;
    }

    /**
     * Advance to the next row, if possible
     *
     * @return true if the current row is valid; false if there
     *  are no more rows
     */
    public boolean nextRow() {
        return m_images.next();
    }

    /**
     * @return the current image asset
     */
    public ImageAsset getImageAsset() {
        return m_images.getImage();
    }

    /**
     * @return the label for the action link
     */
    public String getActionLabel() {
        return "select";
    }
}
