/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.toolbox.ui.DataTable;
import com.arsdigita.util.Lockable;

/**
 * This class is used by the {@link DataTable} class in order
 * to construct a {@link DataCollection} during each request
 */
public interface DataCollectionBuilder extends Lockable {
    public static final String versionId = 
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/DataCollectionBuilder.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    /**
     * Perform all neccessary database operations and return
     * a {@link DataCollection} for the {@link DataTable} to use
     *
     * @param t the parent DataTable
     * @param s the page state
     */
    DataCollection makeDataCollection(DataTable t, PageState s);
}
