/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.xml.Element;

/**
 * Bread crumb trail for a content section.
 *
 * @author Michael Pih
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/ContentSectionNavbar.java#11 $
 */
public class ContentSectionNavbar extends CMSContainer {
    public static final String versionId = 
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/ContentSectionNavbar.java#11 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private DimensionalNavbar m_navbar;

    public ContentSectionNavbar() {
        super();

        setClassAttr("section");

        String wsUrl = 
            "/" + Initializer.getURL(Initializer.WORKSPACE_PAGE_KEY);
        String csUrl = Utilities.getWorkspaceURL();

        m_navbar = new DimensionalNavbar();
        m_navbar.setAlign(DimensionalNavbar.LEFT);
        m_navbar.setDelimiter(" > ");

        m_navbar.add(new Link( new Label(GlobalizationUtil.globalize("cms.ui.content_center")),  csUrl));
        m_navbar.add(new Label(GlobalizationUtil.globalize("cms.ui.content_section")));
        add(m_navbar);
    }


    public void generateXML(PageState state, Element parent) {

        Element element = parent.newChildElement(
            "cms:breadCrumbTrail", CMS.CMS_XML_NS
        );

        ContentSection section = CMS.getContext().getContentSection();
        element.addAttribute("name", section.getName());

        m_navbar.generateXML(state, element);

        exportAttributes(element);
    }

}
