/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.PageLocations;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;

/**
 * Bread crumb trail for a content item.
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #11 $ $Date: 2004/04/07 $
 */
public class ContentItemNavbar extends CMSContainer {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ContentItemNavbar.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static org.apache.log4j.Logger s_log =
        org.apache.log4j.Logger.getLogger(ContentItemNavbar.class);

    private ItemSelectionModel m_item;

    public ContentItemNavbar(ItemSelectionModel item) {
        super();
        m_item = item;
        setClassAttr("item");
    }

    public void generateXML(PageState state, Element parent) {
        Element element = new Element("cms:breadCrumbTrail", CMS.CMS_XML_NS);

        ContentSection section = CMS.getContext().getContentSection();
        ContentItem item = m_item.getSelectedItem(state);
        ContentType type = item.getContentType();

        final String url = URL.there(state.getRequest(),
                                     Utilities.getWorkspaceURL()).toString();

        element.addAttribute("workspaceURL", url);
        element.addAttribute("sectionName", section.getName());

        // If the item is a template, the backlink should go to the root
        // folder, not the templates folder (since the user doesn't know
        // the templates folder exists).

        String returnFolder = "";

        if (! type.getClassName().equals(com.arsdigita.cms.Template.BASE_DATA_OBJECT_TYPE)) {
            returnFolder = "?" + ContentSectionPage.SET_FOLDER + "=" +
                item.getParent().getID().toString();
        }

        element.addAttribute("sectionURL", section.getURL() +
                             PageLocations.SECTION_PAGE +
                             returnFolder);
        element.addAttribute("type", type.getLabel());
        element.addAttribute("name", item.getDisplayName());
        exportAttributes(element);
        parent.addContent(element);
    }

}
