/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.PageState;
import com.arsdigita.toolbox.ui.Cancellable;

/**
 * A convenience class for CMS forms. The "CMS Admin" class eliminates
 * the nested tables created by the Bebop ColumnPanel. This is mainly
 * to increase form rendering.
 *
 * @author Michael Pih
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/CMSForm.java#7 $
 */
public class CMSForm extends Form implements Cancellable {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/CMSForm.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    public static final String CLASS = "CMS Admin";

    public CMSForm(final String name) {
        super(name);

        setClassAttr(CLASS);
        getPanel().setClassAttr(CLASS);
    }

    public CMSForm(final String name, final Container panel) {
        super(name, panel);

        setClassAttr(CLASS);
        panel.setClassAttr(CLASS);
    }

    /**
     * Determines whether the form has been cancelled.
     * Override this method if the form can be cancelled.
     *
     * @param state The page state
     * @return true if the form is cancelled, false otherwise
     */
    public boolean isCancelled(PageState state) {
        return false;
    }
}
