/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Image;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.dispatcher.Utilities;

import javax.servlet.ServletException;


/**
 * Sticks a back button in the upper right hand corner of the component.
 * Just override the back(PageState s) method to use.
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 */
public class BackButton extends ColumnPanel {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/BackButton.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final static String BACK_EVENT = "back";
    private final static String IMAGE_URL =
        Utilities.getGlobalAssetsURL() + "back.gif";

    private Component m_child;
    private ControlLink m_back;

    public BackButton(Component child) {
        super(2);
        setClassAttr("CMS Admin");

        m_child = child;
        add(m_child, ColumnPanel.TOP);

        Image img = new Image(IMAGE_URL);
        img.setBorder("0");
        img.setAlt("Back");
        m_back = new Back(img);
        add(m_back, ColumnPanel.TOP | ColumnPanel.RIGHT);
    }

    /**
     * Remove the selected member from the selected group.
     */
    public void respond(PageState state) throws ServletException {
        String event = state.getControlEventName();

        if ( BACK_EVENT.equals(event) ) {
            back(state);
        }
    }


    /**
     * Called whenever the back button is clicked.
     *
     * Override this method.
     *
     * @param state The page state
     */
    protected void back(PageState state) {
        return;
    }

    /**
     * Register the control event listener to this page.
     */
    public void register(Page p) {
        p.addComponent(this);
    }


    /**
     * The back button.
     */
    private class Back extends ControlLink {

        public Back(Component c) {
            super(c);
        }

        public void setControlEvent(PageState s) {
            s.setControlEvent(BackButton.this, BACK_EVENT, BACK_EVENT);
        }
    }

}
