/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;


import com.arsdigita.bebop.Label;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.util.GlobalizationUtil;

/**
 * <p>Access Denied page</p>
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #8 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class AccessDenied extends CMSPage {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/AccessDenied.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public AccessDenied() {
        super("Access Denied");
        setClassAttr("AccessDenied");

        add(new Label(GlobalizationUtil.globalize("cms.ui.you_do_not_have_sufficient_privileges_to_access_this_page")));
        init();
    }
}
