/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.search;

import com.arsdigita.search.FilterSpecification;

import com.arsdigita.util.Assert;

/**
 * A filter specification for content item versions
 */
public class VersionFilterSpecification extends FilterSpecification {

    public final static String VERSION = "version";
    
    /**
     * Creates a new filter restricting results to items
     * with the specified version
     *
     * @param version the content item version
     */
    public VersionFilterSpecification(String version) {
        super(new Object[] { VERSION, version },
              new VersionFilterType());
    }
    
    /**
     * Returns the version to restrict on
     * @return the version
     */
    public String getVersion() {
        return (String)get(VERSION);
    }
}
