/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.publishToFile;
import java.net.URLConnection;


/**
 * Interface defining a method which sets one or more "passwords" (i.e.
 * cookies) on the request that PublishToFile.readHTML makes to itself to
 * get content to publish.  The cookies can be inspected by application
 * specific code that processes the request to insure that the request
 * is from the server.
 *
 * @see PublishToFile
 *
 * @author Jeff Teeters (teeters@arsdigita.com)
 * @version $Revision: #6 $ $DateTime: 2004/04/07 16:07:11 $
 */


public interface SetLocalRequestPassword {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/publishToFile/SetLocalRequestPassword.java#6 $";

  /**
   * Sets one or more passwords (cookies) on a connection that is the
   * request to the server.
   * @param con  connection being made to server.
   */
  public void setPassword(URLConnection con);

}
