/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.installer.xml;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.TextPage;
import org.apache.log4j.Logger;

/**
 * TextPageHelper
 *
 * @author <a href="mailto:jorris@redhat.com">Jon Orris</a>
 *
 */
public class TextPageHelper extends ContentPageHelper {

    private static final Logger s_log = Logger.getLogger(TextPageHelper.class);
    public TextPageHelper(ContentSection section) {
        super(section);
    }

    public void setBodyText(String body) {
        s_log.warn("Aha. Setting body text to: " + body);
        TextAsset asset = new TextAsset();
        asset.setText(body);

        TextPage page = (TextPage) m_item;
        page.setTextAsset(asset);
        asset.setParent(page);
        asset.setName(page.getName() + "_text_" + page.getID());
        //asset.save();
        //page.save();

        //s_log.warn("Saved the page");

    }
}
