/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import java.util.Hashtable;
import java.util.Map;

/**
 * <p>A basic implementation of the Cache interface.</p>
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #5 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class SimpleCache extends Hashtable{

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/SimpleCache.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public SimpleCache() {
        super();
    }

    public SimpleCache(int initialCapacity) {
        super(initialCapacity);
    }

    public SimpleCache(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public SimpleCache(Map map) {
        super(map);
    }


    /**
     * Lookup and fetch a cached object.
     *
     * @param key The object key
     * @return The cached object, null if there is none
     */
    public Object get(Object key) {
        return super.get(key);
    }

    /**
     * Caches one object.
     *
     * @param key The object key
     * @param value The object to be cached
     * @return The cached object
     */
    public Object put(Object key, Object value) {
        return super.put(key, value);
    }

    /**
     * Removes one cached object.
     *
     * @param key The object key
     * @return The formerly-cached object
     */
    public Object remove(Object key) {
        return super.remove(key);
    }

    /**
     * Clears the cache.
     */
    public void flush() {
        clear();
    }

}
