/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;


import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.util.Assert;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * An interface for resources that can be served.
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #9 $ $DateTime: 2004/04/07 16:07:11 $
 **/
public abstract class ResourceHandlerImpl implements ResourceHandler {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/ResourceHandlerImpl.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";


    /**
     * This method is called by the {@link com.arsdigita.dispatcher.Dispatcher}
     * that initializes this page.
     */
    public void init() throws ServletException {
        // Do nothing.
    }

    /**
     * Fetch the request-local content section.
     *
     * @param request The HTTP request
     * @return The current content section
     */
    public ContentSection getContentSection(HttpServletRequest request) {
        // resets all content sections associations
        ContentSection section = CMSDispatcher.getContentSection(request);
        Assert.assertNotNull(section);
        return section;
    }

    /**
     * Fetch the request-local content item.
     *
     * @param request The HTTP request
     * @return The current content item
     */
    public ContentItem getContentItem(HttpServletRequest request) {
        // resets all content item associations
        return CMSDispatcher.getContentItem(request);
    }

    public void checkUserAccess(HttpServletRequest request,
                                HttpServletResponse response,
                                RequestContext actx,
                                ContentItem item) {
        User user = KernelHelper.getCurrentUser(request);

        PrivilegeDescriptor view = PrivilegeDescriptor.get
            (SecurityManager.CMS_READ_ITEM);
        PermissionDescriptor perm = new PermissionDescriptor(view, item, user);

        if (!PermissionService.checkPermission(perm)) {
            throw new AccessDeniedException( (String) GlobalizationUtil.globalize("cms.dispatcher.no_permission_to_access_resource").localize());
        }
    }


    /**
     * Services this resource.
     *
     * @param request The servlet request object
     * @param response the servlet response object
     * @param actx The request context
     */
    public abstract void dispatch(HttpServletRequest request,
                                  HttpServletResponse response,
                                  RequestContext actx)
        throws IOException, ServletException;

}
