/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.dispatcher.Dispatcher;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;


/**
 * An interface for resources that can be served.
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #7 $ $DateTime: 2004/04/07 16:07:11 $
 **/
public interface ResourceHandler extends Dispatcher {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/ResourceHandler.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * This method is called by the {@link com.arsdigita.dispatcher.Dispatcher}
     * that initializes this page.
     */
    public void init() throws ServletException;

    /**
     * Fetches the content section context for this resource.
     *
     * @param request The HTTP request
     * @return A content section or null if there is none
     * @pre ( request != null )
     */
    public ContentSection getContentSection(HttpServletRequest request);

    /**
     * Fetches the content item context for this resource.
     *
     * @param request The HTTP request
     * @return A content item or null if there is none
     * @pre ( request != null )
     */
    public ContentItem getContentItem(HttpServletRequest request);

}
