/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.util.Assert;

import javax.servlet.http.HttpServletRequest;


/**
 * <p>A {@link com.arsdigita.cms.dispatcher.CMSPage} used for serving
 * content items.</p>
 *
 * <p>This page contains a <code>ContentPanel</code> component which fetches
 * the {@link com.arsdigita.cms.dispatcher.XMLGenerator} for the content
 * section.</p>
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #6 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class MasterPage extends CMSPage {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/MasterPage.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public MasterPage() {
        super("Master", new SimpleContainer());
        setIdAttr("master_page");

        add(new ContentPanel());
    }

    /**
     * Fetch the request-local content section.
     *
     * @param request The HTTP request
     * @return The current content section
     */
    public ContentSection getContentSection(HttpServletRequest request) {
        // Resets all content sections associations.
        ContentSection section = super.getContentSection(request);
        Assert.assertNotNull(section);
        return section;
    }


}
