/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.PageState;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;

/**
 * <p><tt>CategoryItemResolver</tt> extends the <tt>ItemResolver</tt>
 * interface to provide alternate methods for generating item URLs
 * which take a Category as input, allowing for a URL generation
 * scheme which produces different URLs for an item in different categories</p>
 *
 *
 * @author Scott Seago (sseago@redhat.com)
 * @version $Revision: #5 $ $DateTime: 2004/04/07 16:07:11 $ */
public interface CategoryItemResolver extends ItemResolver {



    /**
     * Gets the category for the current request (if set by
     *    getItem(section, url, context)
     *
     * @param request The current request
     *
     * @return the Category for the current request
     */
    public Category getCategory(HttpServletRequest request);
    
    /**
     * Gets the category path for the current request (if set by
     *    getItem(section, url, context)
     *
     * @param request The current request
     *
     * @return the Category path for the current request
     */
    public Category[] getCategoryPath(HttpServletRequest request);

    /**
     * Whether the current request is an index item request (i.e. the
     * item name is not specified in the URL)
     *
     * @param request The current request
     *
     * @return Whether the current request is an index item request
     */
    public boolean isIndexRequest (HttpServletRequest request);

    /**
     * Generates a URL for a content item.
     *
     * @param itemId The item ID
     * @param name The name of the content page
     * @param state The page state
     * @param section the content section to which the item belongs
     * @param context the context of the URL, such as "live" or "admin"
     * @param category the Category to use as the context for
     * generating the URL
     * @return The URL of the item
     * @see #getCurrentContext
     */
    public String generateItemURL (
                                   PageState state, BigDecimal itemId, String name,
                                   ContentSection section, String context, Category category
                                   );

    /**
     * Generates a URL for a content item.
     *
     * @param itemId The item ID
     * @param name The name of the content page
     * @param state The page state
     * @param section the content section to which the item belongs
     * @param context the context of the URL, such as "live" or "admin"
     * @param templateContext the context for the URL, such as "public"
     * @param category the Category to use as the context for
     * @return The URL of the item
     * @see #getCurrentContext
     */
    public String generateItemURL (
                                   PageState state, BigDecimal itemId, String name,
                                   ContentSection section, String context, String templateContext,
				   Category category
                                   );

    /**
     * Generates a URL for a content item.
     *
     * @param item The item
     * @param state The page state
     * @param section the content section to which the item belongs
     * @param context the context of the URL, such as "live" or "admin"
     * @param category the Category to use as the context for
     * @return The URL of the item
     * @see #getCurrentContext
     */
    public String generateItemURL (
                                   PageState state, ContentItem item, ContentSection section, 
				   String context, Category category
                                   );

    /**
     * Generates a URL for a content item.
     *
     * @param item The item
     * @param state The page state
     * @param section the content section to which the item belongs
     * @param context the context of the URL, such as "live" or "admin"
     * @param templateContext the context for the URL, such as "public"
     * @param category the Category to use as the context for
     * @return The URL of the item
     * @see #getCurrentContext
     */
    public String generateItemURL (
                                   PageState state, ContentItem item, ContentSection section, 
				   String context, String templateContext, Category category
                                   );

}
