/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.mimetypes.MimeType;

/**
 * <p>This class contains a collection of {@link
 * com.arsdigita.cms.ItemTemplateMapping item template mappings}.</p>
 *
 * @author Stanislav Freidin (sfreidin@arsdigita.com)
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ItemTemplateCollection.java#11 $
 * @see com.arsdigita.domain.DomainCollection
 * @see com.arsdigita.persistence.DataCollection
 * @see com.arsdigita.cms.ItemTemplateCollection
 */
class ItemTemplateCollection extends TemplateCollection {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ItemTemplateCollection.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

  /**
   * Constructor.
   *
   **/
  public ItemTemplateCollection(DataCollection dataCollection) {
    super(dataCollection);
  }

  /**
   * Returns a <code>DomainObject</code> for the current position in
   * the collection.
   *
   */
  public DomainObject getDomainObject() {
    return DomainObjectFactory.newInstance
        (m_dataCollection.getDataObject());
  }

    /**
     * Return the current template
     */
    public Template getTemplate() {
        ItemTemplateMapping m = (ItemTemplateMapping)getDomainObject();
        if(m == null) return null;
        return m.getTemplate();
    }

    /**
     * Return the current content item
     */
    public ContentItem getContentItem() {
        ItemTemplateMapping m = (ItemTemplateMapping)getDomainObject();
        if(m == null) return null;
        return m.getContentItem();
    }

  /**
   * Return the current use context
   */
  public String getUseContext() {
    return (String) m_dataCollection.get("useContext");
  }

    /**
     *  this is the mime type for this context but does not necessarily
     *  have to be the same mime type that is returned by calling
     *  getTemplate().getMimeType().  This can return null
     */
    public MimeType getMimeType() {
        DataObject object = (DataObject)m_dataCollection.get("mimeType");
        if (object != null) {
            return new MimeType(object);
        } else {
            return super.getMimeType();
        }
    }

  /**
   * Return true if the current template is the default for its context
   */
  public Boolean isDefault() {
    // FIXME: Why is this here ? The implementation is definitely bogus
    // [lutter]
    return new Boolean(true);
  }
}
