/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import org.apache.log4j.Logger;

/**
 * <p>A central location for commonly used CMS services and their
 * accessories.</p>
 *
 * <p><b>Context.</b> {@link #getContext()} fetches the context record ({@link
 * com.arsdigita.kernel.KernelContext}) of the current thread.</p>
 *
 * @author Daniel Berrange
 * @see com.arsdigita.kernel.Kernel
 */
public abstract class CMS {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/CMS.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    /**
     * The CMS XML namespace.
     */
    public final static String CMS_XML_NS = "http://www.arsdigita.com/cms/1.0";

    private static final Logger s_log = Logger.getLogger(CMS.class);
    
    static final CMSContext s_initialContext = new CMSContext();
    
    private static final ThreadLocal s_context = new ThreadLocal() {
            public Object initialValue() {
                return s_initialContext;
            }
        };

    /**
     * Get the context record of the current thread.
     *
     * @post return != null
     */
    public static final CMSContext getContext() {
        return (CMSContext)s_context.get();
    }
    
    static final void setContext(CMSContext context) {
        s_context.set(context);
    }
}
