/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.workflow;

import com.arsdigita.cms.ui.ContentItemPage;

import java.math.BigDecimal;

/**
 * Class for generating a URL to the Authoring kit given the ID of the
 * ContentItem and the Task. Eventually we may have a separate kit for
 * editors, hence this is a separate class and has its own TaskType
 *
 * @author Uday Mathur (umathur@arsdigita.com)
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 * */

public class EditingTaskURLGenerator implements TaskURLGenerator {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/workflow/EditingTaskURLGenerator.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public EditingTaskURLGenerator() {}

    /**
     * Generates a Link to the Workflow Tab in the Item Management part
     * of the CMS UI.
     *
     * @param itemId a BigDecimal id of the item in question
     * @param taskId this param is ignored.
     * */
    public String generateURL(BigDecimal itemId, BigDecimal taskId) {
        final StringBuffer url = new StringBuffer
            (ContentItemPage.getItemURL(itemId, ContentItemPage.WORKFLOW_TAB));

        // XXX task, approve, and action were constants; restore them
        url.append("&action=approve&task=").append(taskId.toString());

        return url.toString();
    }
}
