/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.util;



/**
 * <p>Security class used for checking and granting privileges in
 * CMS.</p>
 *
 * @author Michael Pih
 * @version $Revision: #6 $ $DateTime: 2004/04/07 16:07:11 $
 */
public interface SecurityConstants {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/util/SecurityConstants.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    // CMS Actions
    public final static String STAFF_ADMIN = "staff_admin";
    public final static String WORKFLOW_ADMIN = "workflow_admin";
    public final static String CATEGORY_ADMIN = "category_admin";
    public final static String LIFECYCLE_ADMIN = "lifecycle_admin";
    public final static String CONTENT_TYPE_ADMIN = "content_type_admin";
    public final static String PUBLISH = "publish";
    public final static String NEW_ITEM = "new_item";
    public final static String PUBLIC_PAGES = "public_pages";
    public final static String PREVIEW_PAGES = "preview_pages";
    public final static String ADMIN_PAGES = "admin_pages";
    public final static String EDIT_ITEM = "edit_item";
    public final static String SCHEDULE_PUBLICATION = "schedule_publication";
    public final static String DELETE_ITEM = "delete_item";
    public final static String APPLY_WORKFLOW = "apply_workflow";
    public final static String CATEGORIZE_ITEMS = "categorize_items";
    public final static String DELETE_IMAGES = "delete_images";
    public final static String APPLY_ALTERNATE_WORKFLOWS = "apply_alternate_workflows";

    // CMS Privileges
    public final static String CMS_APPLY_ALTERNATE_WORKFLOWS = "cms_apply_alternate_workflows";
    public final static String CMS_CATEGORIZE_ITEMS = "cms_categorize_items";
    public final static String CMS_CATEGORY_ADMIN = "cms_category_admin";
    public final static String CMS_CONTENT_TYPE_ADMIN = "cms_content_type_admin";
    public final static String CMS_DELETE_ITEM = "cms_delete_item";
    public final static String CMS_EDIT_ITEM = "cms_edit_item";
    public final static String CMS_ITEM_ADMIN = "cms_item_admin";
    public final static String CMS_LIFECYCLE_ADMIN = "cms_lifecycle_admin";
    public final static String CMS_NEW_ITEM = "cms_new_item";
    public final static String CMS_PREVIEW_ITEM = "cms_preview_item";
    public final static String CMS_PUBLISH = "cms_publish";
    public final static String CMS_READ_ITEM = "cms_read_item";
    public final static String CMS_STAFF_ADMIN = "cms_staff_admin";
    public final static String CMS_WORKFLOW_ADMIN = "cms_workflow_admin";
}
