/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.toolbox.Security;
import com.arsdigita.toolbox.ui.ComponentAccess;
import org.apache.log4j.Logger;

/**
 * A <code>ComponentAccess</code> implementation that respects workflow
 *
 * @author Stanislav Freidin
 * @author Uday Mathur
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/WorkflowLockedComponentAccess.java#8 $
 */
public class WorkflowLockedComponentAccess extends ComponentAccess {

    private static final Logger s_log =
        Logger.getLogger(WorkflowLockedComponentAccess.class);

    ItemSelectionModel m_itemModel;
    /**
     * @param c The component
     */
    public WorkflowLockedComponentAccess(Component c, ItemSelectionModel i) {
        super(c);
        m_itemModel = i;
    }

    /**
     * @param c The component
     * @param check An access check
     */
    public WorkflowLockedComponentAccess(Component c, String check, ItemSelectionModel i) {
        super(c,check);
        m_itemModel = i;
    }

    /**
     * Check if this item is locked from the workflow module. In
     * addition check if all the access checks registered to the
     * component pass.
     *
     * @param state The page state
     * @param security The Security implementation that will perform
     *    the access checks
     * @return true if all the access checks pass, false otherwise
     * */
   public boolean canAccess(PageState state, Security security) {
         SecurityManager sm = Utilities.getSecurityManager(state);
         ContentItem item = (ContentItem)m_itemModel.getSelectedObject(state);

         if (super.canAccess(state, security)) {
             boolean smCheck = sm.canAccess(state.getRequest(), SecurityManager.EDIT_ITEM,
                                            item);
             if ( s_log.isDebugEnabled() ) {
                 s_log.debug("Superclass security check passed. SecurityManager check is " + 
                             smCheck);
             }
             return smCheck;
         }

         s_log.warn("Returning false");

         return false;
   }
}
