/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.ui.BaseAdminPane;
import com.arsdigita.cms.ui.BaseDeleteForm;
import com.arsdigita.cms.ui.VisibilityComponent;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import org.apache.log4j.Logger;

import java.math.BigDecimal;

/**
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/WorkflowAdminPane.java#13 $
 */
public final class WorkflowAdminPane extends BaseAdminPane {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/WorkflowAdminPane.java#13 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (WorkflowAdminPane.class);

    private final WorkflowRequestLocal m_workflow;

    public WorkflowAdminPane() {
        super(gz("cms.ui.workflows"), new WorkflowListModelBuilder());

        m_workflow = new SelectionRequestLocal();

        setAdd(gz("cms.ui.workflow.add"),
               new WorkflowAddForm(getSelectionModel()));
        setEdit(gz("cms.ui.workflow.edit"), new WorkflowEditForm(m_workflow));
        setDelete(gz("cms.ui.workflow.delete"), new DeleteForm());

        setIntroPane(new Label(gz("cms.ui.workflow.intro")));
        setItemPane(new WorkflowItemPane(m_workflow,
                                         getEditLink(),
                                         getDeleteLink()));

        addAction(new VisibilityComponent(getAddLink(),
                                          SecurityManager.WORKFLOW_ADMIN));
    }

    private class DeleteForm extends BaseDeleteForm {
        DeleteForm() {
            super(gz("cms.ui.workflow.delete_prompt"));

            addSecurityListener(SecurityManager.WORKFLOW_ADMIN);
        }

        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();

            m_workflow.getWorkflow(state).delete();

            getSelectionModel().clearSelection(state);
        }
    }

    private class SelectionRequestLocal extends WorkflowRequestLocal {
        protected final Object initialValue(final PageState state) {
            final String id = getSelectionModel().getSelectedKey
                (state).toString();

            return new WorkflowTemplate(new BigDecimal(id));
        }
    }
}
