/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import org.apache.log4j.Logger;

import java.math.BigDecimal;
import java.util.TooManyListenersException;

/**
 * This panel displays a radio group of available Workflow Templates
 * in this content section that can be applied to this item.
 *
 * @author Uday Mathur
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/ItemWorkflowSelectForm.java#6 $
 */
class ItemWorkflowSelectForm extends CMSForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/ItemWorkflowSelectForm.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";
    
    private static final Logger s_log = Logger.getLogger(ItemWorkflowSelectForm.class);

    private RadioGroup m_radio;

    public ItemWorkflowSelectForm() {
        super("applyWorkflow", new SimpleContainer());

        addFormWidgets();
        addProcessListener(new ProcessListener());
    }

    protected void addFormWidgets() {
        m_radio = new RadioGroup(new BigDecimalParameter("workflowSelect"));
        m_radio.setClassAttr("vertical");

        try {
            m_radio.addPrintListener(new WorkflowsOptionPrintListener());
        } catch (TooManyListenersException t) {
            s_log.error("Too many listeners", t);
        }

        m_radio.addValidationListener(new NotNullValidationListener());
        add(m_radio);

        add(new Submit("apply_wf", "Apply Workflow"));
    }

     // Adds a FormProcessListener to that applies a clone of the
     // WorkflowTemplate to this ContentItem. In case of double-click,
     // no change is made.
    private class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();
            final BigDecimal flowID = (BigDecimal) m_radio.getValue(state);

            // XXX hideous hack
            final BigDecimal itemID =
                CMS.getContext().getContentItem().getID();

            if (Workflow.getObjectWorkflowID(itemID) == null) {
                final WorkflowTemplate template = new WorkflowTemplate(flowID);

                final Workflow flow = template.instantiateNewWorkflow();

                flow.setObjectID(itemID);
                flow.start(Web.getContext().getUser());
                flow.save();
            }
        }
    }
}
