/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.toolbox.ui.LayoutPanel;
import com.arsdigita.workflow.simple.Workflow;

import java.math.BigDecimal;

/**
 * Panel for applying a workflow template to a content item. By
 * default this panel display a list of workflows that can be applied
 * to the content item. If a workflow is applied, it displays the item
 * details page.
 *
 * @author Uday Mathur
 * @author Michael Pih
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/ItemWorkflowAdminPane.java#11 $
 */
public class ItemWorkflowAdminPane extends BaseItemPane {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/ItemWorkflowAdminPane.java#11 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private final ParameterSingleSelectionModel m_model;
    private final WorkflowRequestLocal m_workflow;

    private final LayoutPanel m_detailPane;
    private final LayoutPanel m_selectPane;

    public ItemWorkflowAdminPane(final BigDecimalParameter itemIdParameter) {
        m_model = new ItemWorkflowSelectionModel(itemIdParameter);
        m_workflow = new SelectionRequestLocal();

        final ActionLink editLink = new ActionLink
            (new Label(gz("cms.ui.workflow.edit")));

        final WorkflowEditForm editForm = new WorkflowEditForm(m_workflow);

        final ActionLink deleteLink = new ActionLink
            (new Label(gz("cms.ui.workflow.delete")));

        final WorkflowDeleteForm deleteForm = new WorkflowDeleteForm
            (m_workflow);

        m_detailPane = new LayoutPanel();
        m_detailPane.setBody(new ItemWorkflowItemPane
                             (m_workflow, editLink, deleteLink));

        final ItemWorkflowSelectForm workflowSelectForm =
            new ItemWorkflowSelectForm();

        m_selectPane = new LayoutPanel();
        m_selectPane.setBody(workflowSelectForm);

        add(m_detailPane);
        setDefault(m_detailPane);
        add(m_selectPane);
        add(editForm);
        add(deleteForm);

        connect(workflowSelectForm, m_detailPane);
        connect(editLink, editForm);
        connect(deleteLink, deleteForm);
        connect(deleteForm, m_selectPane);
    }

    private class SelectionRequestLocal extends WorkflowRequestLocal {
        protected final Object initialValue(final PageState state) {
            final String id = m_model.getSelectedKey(state).toString();

            return new Workflow(new BigDecimal(id));
        }
    }

    public final void register(final Page page) {
        super.register(page);

        page.addActionListener(new ActionListener() {
                public final void actionPerformed(final ActionEvent e) {
                    final PageState state = e.getPageState();

                    if (state.isVisibleOnPage(ItemWorkflowAdminPane.this)
                            && m_model.getSelectedKey(state) == null) {
                        push(state, m_selectPane);
                    }
                }
            });
    }
}
