/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.web.Web;
import org.apache.log4j.Logger;

import java.math.BigDecimal;

public final class AssignedTaskTable extends Table {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/AssignedTaskTable.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (AssignedTaskTable.class);

    public AssignedTaskTable(final WorkflowRequestLocal workflow) {
        super(new AssignedTaskTableModelBuilder(workflow),
              new String[] { lz("cms.ui.name"), "", "" });

        // XXX The string array and setHeader(null) are a product of
        // messed up Table behavior.

        setEmptyView(new Label(gz("cms.ui.workflow.task.assigned.none")));

        addTableActionListener(new LockListener());
        //addTableActionListener(new FinishListener());

        getColumn(1).setCellRenderer(new CellRenderer());
        getColumn(2).setCellRenderer(new DefaultTableCellRenderer(true));
    }

    private static class LockListener extends TableActionAdapter {
        public final void cellSelected(final TableActionEvent e) {
            final int column = e.getColumn().intValue();

            if (column == 1) {
                final CMSTask task = new CMSTask
                    (new BigDecimal(e.getRowKey().toString()));

                if (task.isLocked()) {
                    task.unlock(Web.getContext().getUser());
                } else {
                    task.lock(Web.getContext().getUser());
                }

                task.save();
            }
        }
    }

//     private static class FinishListener extends TableActionAdapter {
//         public final void cellSelected(final TableActionEvent e) {
//             final PageState state = e.getPageState();
//             final int column = e.getColumn().intValue();

//             if (column == 2) {
//                 final CMSTask task = new CMSTask
//                     (new BigDecimal(e.getRowKey().toString()));

//                 try {
//                     task.finish();
//                 } catch (TaskException te) {
//                     throw new UncheckedWrapperException(te);
//                 }
//             }
//         }
//     }

    private class CellRenderer implements TableCellRenderer {
        public final Component getComponent(final Table table,
                                            final PageState state,
                                            final Object value,
                                            final boolean isSelected,
                                            final Object key,
                                            final int row,
                                            final int column) {
            if (value.equals(Boolean.TRUE)) {
                return new ControlLink
                    (new Label(gz("cms.ui.workflow.task.unlock")));
            } else {
                return new ControlLink
                    (new Label(gz("cms.ui.workflow.task.lock")));
            }
        }
    }

    protected final static GlobalizedMessage gz(final String key) {
        return GlobalizationUtil.globalize(key);
    }

    protected final static String lz(final String key) {
        return (String) gz(key).localize();
    }
}
