/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.dispatcher.AccessDeniedException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import org.apache.log4j.Logger;

/**
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/type/TypeSecurityListener.java#5 $
 */
final class TypeSecurityListener implements FormSubmissionListener {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/type/TypeSecurityListener.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static Logger s_log = Logger.getLogger(TypeSecurityListener.class);

    public final void submitted(final FormSectionEvent e)
            throws FormProcessException {
        final PageState state = e.getPageState();
        final Party party = Kernel.getContext().getParty();
        final SecurityManager sm = Utilities.getSecurityManager(state);

        if (!sm.canAccess(party, SecurityManager.CONTENT_TYPE_ADMIN)) {
            throw new AccessDeniedException();
        }
    }
}
