/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.role;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Role;
import org.apache.log4j.Logger;

/**
 * @author Michael Pih
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ui/role/RoleAddForm.java#8 $
 */
final class RoleAddForm extends BaseRoleForm {
    public static final String versionId =
        "$Id: //cms/dev/src/com/arsdigita/cms/ui/role/RoleAddForm.java#8 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(RoleAddForm.class);

    private SingleSelectionModel m_model;
    private final boolean m_useViewersGroup;

    public RoleAddForm(SingleSelectionModel model, boolean useViewersGroup) {
        super("AddStaffRole", gz("cms.ui.role.add"), useViewersGroup);

        m_model = model;
        m_useViewersGroup = useViewersGroup;

        m_name.addValidationListener(new NameUniqueListener(null));

        addProcessListener(new ProcessListener());
    }

    private class ProcessListener implements FormProcessListener {
        public final void process(final FormSectionEvent e)
                throws FormProcessException {
            final PageState state = e.getPageState();
            final ContentSection section =
                CMS.getContext().getContentSection();

            Group group;

            if (m_useViewersGroup) {
                group = section.getViewersGroup();
            } else {
                group = section.getStaffGroup();
            }

            final Role role = group.createRole
                ((String) m_name.getValue(state));
            role.setName((String) m_name.getValue(state));
            role.setDescription((String) m_description.getValue(state));

            group.save();

            RoleFactory.updatePrivileges
                (role,
                 (String[]) m_privileges.getValue(state),
                 CMS.getContext().getContentSection());

            role.save();

            m_model.setSelectedKey(state, role.getID().toString());
        }
    }
}
