/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui.portlet;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.portal.PortletConfigFormSection;
import com.arsdigita.cms.portlet.TaskPortlet;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.portal.Portlet;



public class TaskPortletEditor extends PortletConfigFormSection {
    
    private int m_maxTasks;
    private TextField m_numTasks;
    private ResourceType m_resType;

    public TaskPortletEditor(ResourceType resType,
                             RequestLocal parentAppRL) {
        super(resType, parentAppRL);
    }
    
    public TaskPortletEditor(RequestLocal application) {
        super(application);
    }
    
    
    protected void addWidgets() {
        super.addWidgets();

        m_numTasks = new TextField(new IntegerParameter("numTasks"));
        m_numTasks.setSize(3);
        m_numTasks.addValidationListener(new NotNullValidationListener());
        
        add(new Label("Number of Tasks to display:", Label.BOLD), ColumnPanel.RIGHT);
        add(m_numTasks);
    }
    
    protected void initWidgets(PageState state,
                               Portlet portlet)
        throws FormProcessException {
        super.initWidgets(state, portlet);
        
        if (portlet != null) {
            TaskPortlet myportlet = (TaskPortlet)portlet;
            
            m_numTasks.setValue(state, new Integer(myportlet.getMaxNumTasks()));
        } else {
            m_numTasks.setValue(state, new Integer(5));
        }
    }
    
    protected void processWidgets(PageState state,
                                  Portlet portlet)
        throws FormProcessException {
        super.processWidgets(state, portlet);
        
        TaskPortlet myportlet = (TaskPortlet)portlet;
        myportlet.setMaxNumTasks(((Integer)m_numTasks.getValue(state)).intValue());
    }
}
